package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author hupan
 * @date 2023/6/27 18:13
 */
@Getter
public enum LabelManageEnum {
  AUTOMATIC_LABEL("0","手动标签"),
  MANUAL_LABEL("1","自动标签");

  private String value;
  private String desc;

  LabelManageEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (LabelManageEnum o : LabelManageEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (LabelManageEnum o : LabelManageEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    LabelManageEnum[] types = LabelManageEnum.values();
    for(LabelManageEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
