package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 会员激活状态
 */
@Getter
public enum MemberActiveStatusEnum {
    STAY_ACTIVE("stay_active", "未激活"),
    HAS_ACTIVE("has_active", "已激活");

    private String value;
    private String desc;

    MemberActiveStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (MemberActiveStatusEnum o : MemberActiveStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (MemberActiveStatusEnum o : MemberActiveStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        MemberActiveStatusEnum[] types = MemberActiveStatusEnum.values();
        for(MemberActiveStatusEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
