package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 会员审批状态
 */
@Getter
public enum MemberApprovalStatusEnum {
    STAY("stay", "未审批"),
    PASS("pass", "已通过"),
    REJECT("reject", "已驳回");

    private String value;
    private String desc;

    MemberApprovalStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (MemberApprovalStatusEnum o : MemberApprovalStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (MemberApprovalStatusEnum o : MemberApprovalStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        MemberApprovalStatusEnum[] types = MemberApprovalStatusEnum.values();
        for(MemberApprovalStatusEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
