package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 会员权益兑换状态
 */
@Getter
public enum MemberInfoBenefitsStatusEnum {
    STAY_EXCHANGE("stay_exchange", "未兑换"),
    HAS_EXCHANGE("has_exchange", "已兑换"),
    HAS_EXPIRED("has_expired", "已过期"),
    HAS_GIFT("has_gift", "已转赠");

    private String value;
    private String desc;

    MemberInfoBenefitsStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (MemberInfoBenefitsStatusEnum o : MemberInfoBenefitsStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (MemberInfoBenefitsStatusEnum o : MemberInfoBenefitsStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        MemberInfoBenefitsStatusEnum[] types = MemberInfoBenefitsStatusEnum.values();
        for(MemberInfoBenefitsStatusEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
