package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 数据字典: mms_member_info_integral_use_status
 * @author hupan
 * @date 2023/6/27 11:12
 */
@Getter
public enum MemberInfoIntegralUseStatusEnum {

  ALREADY_USED("already_used", "已使用"),
  NOT_USED("not_used", "未使用"),
  PARTIAL_USED("partial_used", "部分使用");

  private String value;
  private String desc;

  MemberInfoIntegralUseStatusEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (MemberInfoIntegralUseStatusEnum o : MemberInfoIntegralUseStatusEnum
        .values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (MemberInfoIntegralUseStatusEnum o : MemberInfoIntegralUseStatusEnum
        .values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    MemberInfoIntegralUseStatusEnum[] types = MemberInfoIntegralUseStatusEnum
        .values();
    for(MemberInfoIntegralUseStatusEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
