package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 会员权益类型
 */
@Getter
public enum MemberInfoMemberBenefitsTypeEnum {
    MEMBER_BENEFITS("member_benefits", "会员权益"),
    TASTING_BENEFITS("tasting_benefits", "品鉴顾问权益");

    private String value;
    private String desc;

    MemberInfoMemberBenefitsTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (MemberInfoMemberBenefitsTypeEnum o : MemberInfoMemberBenefitsTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (MemberInfoMemberBenefitsTypeEnum o : MemberInfoMemberBenefitsTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        MemberInfoMemberBenefitsTypeEnum[] types = MemberInfoMemberBenefitsTypeEnum.values();
        for(MemberInfoMemberBenefitsTypeEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
