package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 开屏弹窗枚举
 *
 * @Description
 * @Author monroe
 * @Date 2023/7/4 13:56
 **/
public enum MessageFrequencyEnum {

    DAY("day", "每日");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    MessageFrequencyEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (MessageFrequencyEnum shelfStatusEnum : MessageFrequencyEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static MessageFrequencyEnum codeToEnum(String code) {
        MessageFrequencyEnum statusEnum = null;
        for (MessageFrequencyEnum shelfStatusEnum : MessageFrequencyEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            MessageFrequencyEnum[] values = MessageFrequencyEnum.values();
            for (MessageFrequencyEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        MessageFrequencyEnum[] values = MessageFrequencyEnum.values();
        for (MessageFrequencyEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
