package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 订单结算状态
 * @author zouhs
 * @date 2023/6/28
 */
@Getter
public enum  OrderSettleStatusEnum {
  STAY_SETTLE("stay_settle", "未结算"),
  LOAD_SETTLE("load_settle", "结算中"),
  HAS_SETTLE("has_settle", "已结算"),
  REJECT_SETTLE("reject_settle", "已驳回");

  private String value;
  private String desc;

  OrderSettleStatusEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (OrderSettleStatusEnum o : OrderSettleStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (OrderSettleStatusEnum o : OrderSettleStatusEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    OrderSettleStatusEnum[] types = OrderSettleStatusEnum.values();
    for(OrderSettleStatusEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
