package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 权益类型，数据字典：mms_order_source
 */
@Getter
public enum OrderSourceEnum {
    POINTS_MALL("points_mall", "积分商城"),
    MEMBER_ROLE("member_role", "VIP权益"),
    TASTE_CUSTOMER("taste_customer", "品鉴顾问"),
    INTERACT_ACTIVITY("interact_activity", "互动活动");


    private String value;
    private String desc;

    OrderSourceEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (OrderSourceEnum o : OrderSourceEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (OrderSourceEnum o : OrderSourceEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        OrderSourceEnum[] types = OrderSourceEnum.values();
        for(OrderSourceEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
