package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 数据字典: mms_points_view_detail
 *
 * @author hupan
 * @date 2023/6/27 13:47
 */
@Getter
public enum PointsViewDetailAPIEnum {
  ALL_TYPE("all_type", "全部"),
  INCOME("income", "收入"),
  EXPENDITURE("expenditure", "支出"),
  DEDUCTION("deduction", "扣减");

  private String value;
  private String desc;
  PointsViewDetailAPIEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public static Boolean isExist(String value) {
    for (PointsViewDetailAPIEnum o : PointsViewDetailAPIEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return true;
      }
    }
    return false;
  }

  public static String getDescByValue(String value) {
    for (PointsViewDetailAPIEnum o : PointsViewDetailAPIEnum.values()) {
      if (StringUtils.equals(o.getValue(), value)) {
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   *
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if (StringUtils.isBlank(code)) {
      return "未知";
    }
    PointsViewDetailAPIEnum[] types = PointsViewDetailAPIEnum.values();
    for (PointsViewDetailAPIEnum type : types) {
      if (type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
