package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 奖品发完选项
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 18:20
 **/
public enum PrizeOverSelectEnum {

    NONE("1","不中奖"),
    NEXT("2","中下一级奖"),
    NO_INVENTORY("3","无库存奖品");


    @EnumValue
    @JsonValue
    private String code;
    private String des;

    PrizeOverSelectEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (PrizeOverSelectEnum shelfStatusEnum : PrizeOverSelectEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static PrizeOverSelectEnum codeToEnum(String code) {
        PrizeOverSelectEnum statusEnum = null;
        for (PrizeOverSelectEnum shelfStatusEnum : PrizeOverSelectEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            PrizeOverSelectEnum[] values = PrizeOverSelectEnum.values();
            for (PrizeOverSelectEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        PrizeOverSelectEnum[] values = PrizeOverSelectEnum.values();
        for (PrizeOverSelectEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
