package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 奖品类型
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/27 09:35
 **/
public enum PrizeTypeEnum {

    REAL("0","实物"),
    VIRTUAL("1","虚拟"),
    INTEGRAL("3","积分"),
    THANKS("4","谢谢参与");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    PrizeTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (PrizeTypeEnum deliveryFrequencyEnum : PrizeTypeEnum.values()) {
            codes.add(deliveryFrequencyEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static PrizeTypeEnum codeToEnum(String code) {
        PrizeTypeEnum frequencyEnum = null;
        for (PrizeTypeEnum deliveryFrequencyEnum : PrizeTypeEnum.values()) {
            if (deliveryFrequencyEnum.code.equals(code)) {
                frequencyEnum = deliveryFrequencyEnum;
            }
        }
        return frequencyEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            PrizeTypeEnum[] values = PrizeTypeEnum.values();
            for (PrizeTypeEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        PrizeTypeEnum[] values = PrizeTypeEnum.values();
        for (PrizeTypeEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
