package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 产品来源枚举
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 11:43
 **/
public enum ProductSourceEnum {

    BUILD("1","自建产品"),
    MAIN("2","主数据产品");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ProductSourceEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ProductSourceEnum deliveryFrequencyEnum : ProductSourceEnum.values()) {
            codes.add(deliveryFrequencyEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ProductSourceEnum codeToEnum(String code) {
        ProductSourceEnum frequencyEnum = null;
        for (ProductSourceEnum deliveryFrequencyEnum : ProductSourceEnum.values()) {
            if (deliveryFrequencyEnum.code.equals(code)) {
                frequencyEnum = deliveryFrequencyEnum;
            }
        }
        return frequencyEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ProductSourceEnum[] values = ProductSourceEnum.values();
            for (ProductSourceEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ProductSourceEnum[] values = ProductSourceEnum.values();
        for (ProductSourceEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
