package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 实物订单状态
 */
@Getter
public enum RealOrderStatusEnum {
    STAY_DELIVERY("stay_delivery", "待配送"),
    IN_DELIVERY("in_delivery", "配送中"),
    HAS_WRITE_OFF("has_write_off", "已核销"),
    STAY_SHIP("stay_ship", "待发货"),
    HAS_SHIP("has_ship", "已发货"),
    HAS_FINISH("has_finish", "已完成");

    private String value;
    private String desc;

    RealOrderStatusEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (RealOrderStatusEnum o : RealOrderStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (RealOrderStatusEnum o : RealOrderStatusEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        RealOrderStatusEnum[] types = RealOrderStatusEnum.values();
        for(RealOrderStatusEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
