package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 实物订单类型
 */
@Getter
public enum RealOrderTypeEnum {
    MARKET_ORDER("market_order", "市场配送订单"),
    TOTAL_ORDER("total_order", "总部订单");

    private String value;
    private String desc;

    RealOrderTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static Boolean isExist(String value){
        for (RealOrderTypeEnum o : RealOrderTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return true;
            }
        }
        return false;
    }
    public static String getDescByValue(String value){
        for (RealOrderTypeEnum o : RealOrderTypeEnum.values()) {
            if(StringUtils.equals(o.getValue(),value)){
                return o.getDesc();
            }
        }
        return null;
    }


    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getNameByCode(String code) {
        if(StringUtils.isBlank(code)){
            return "未知";
        }
        RealOrderTypeEnum[] types = RealOrderTypeEnum.values();
        for(RealOrderTypeEnum type : types) {
            if(type.getValue().equals(code)) {
                return type.getDesc();
            }
        }
        return "未知";
    }

}
