package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author hupan
 * @date 2023/6/20 10:20
 */
@Getter
public enum ScenicImageTypeEnum {
  ANCHOR_ICON("anchor_icon", "锚点icon"),
  BACKGROUND_PICTURE("background_picture", "景区背景图"),
  SCENIC_ICON("scenic_icon","景区icon"),
  SCENIC_PICTURE("scenic_picture","景点图片"),
  THUMBNAIL_PICTURE("thumbnail_picture","缩略图片"),
  SCENIC_VR_PICTURE("scenic_VR_picture","景点VR图片"),
  SCENIC_VR_VIDEO("scenic_VR_video","景点VR视频");

  private String value;
  private String desc;

  ScenicImageTypeEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (ScenicImageTypeEnum o : ScenicImageTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (ScenicImageTypeEnum o : ScenicImageTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    ScenicImageTypeEnum[] types = ScenicImageTypeEnum.values();
    for(ScenicImageTypeEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
