package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 *上架状态枚举
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 17:14
 **/
public enum ShelfStatusEnum {

    UP("1","上架"),
    DOWN("0","下架");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ShelfStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ShelfStatusEnum shelfStatusEnum : ShelfStatusEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ShelfStatusEnum codeToEnum(String code) {
        ShelfStatusEnum statusEnum = null;
        for (ShelfStatusEnum shelfStatusEnum : ShelfStatusEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ShelfStatusEnum[] values = ShelfStatusEnum.values();
            for (ShelfStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ShelfStatusEnum[] values = ShelfStatusEnum.values();
        for (ShelfStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
