package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 跳转类型
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/29 15:43
 **/
public enum SkipTypeEnum {

    OUT("2","内部跳转"),
    NO("3","不跳转"),
    INNER("1", "内部跳转");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    SkipTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (SkipTypeEnum shelfStatusEnum : SkipTypeEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static SkipTypeEnum codeToEnum(String code) {
        SkipTypeEnum statusEnum = null;
        for (SkipTypeEnum shelfStatusEnum : SkipTypeEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            SkipTypeEnum[] values = SkipTypeEnum.values();
            for (SkipTypeEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        SkipTypeEnum[] values = SkipTypeEnum.values();
        for (SkipTypeEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
