package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 枚举数据字典：mms_system_settings_detail
 *
 * @author hupan
 * @date 2023/6/25 13:45
 */
@Getter
public enum SystemSettingsDetailEnum {
  VALIDITY_PERIOD_OF_POINTS("validity_period_of_points","积分有效期(月)"),
  CONTINUOUS_X_LEVEL_MEMBER("continuous_x_level_member","连续x年等级会员以上"),
  BIRTHDAY_BENEFITS("birthday_benefits","生日礼遇"),
  TASTING_SEND_WINE("tasting_send_wine","品鉴赠酒"),
  ECOLOGICAL_TOUR("ecological_tour","生态之旅"),
  CARD_IMAGE("card_image","名片图片"),
  MEMBERSHIP_CARD("membership_card","会员名片"),
  INVITATION_POINTS_RATIO("invitation_points_ratio","邀请积分比例"),
  MEMBERSHIP_THRESHOLD("membership_threshold","会员门槛(成长值)"),
  SIGNING_RECORD_STATISTICS_TIME("signing_record_statistics_time","签收记录统计时间"),
  FLAG_NEED_APPROVAL("flag_need_approval","是否需要审批"),
  ANSWERING_CORRECTLY_POINTS("answering_correctly_points","答对可获得积分(分/题)"),
  MAX_POINTS_PER_MONTH("max_points_per_month","每人每月可获得积分上限(分/月)"),
  ACTIVITY_RULES("activity_rules","活动规则"),
  ONLINE_CUSTOMER_SERVICE_SETTINGS("online_customer_service_settings","在线客服设置"),
  TELEPHONE_CUSTOMER_SERVICE_SETTINGS("telephone_customer_service_settings","电话客服设置"),
  CUSTOMER_SERVICE_TELEPHONE("customer_service_telephone","客服电话"),
  UPGRADE_RULE_DESC("upgrade_rule_desc","升级规则说明"),
  CARD_PAGE_COMPANY_PROFILE("card_page_company_profile","名片页面公司介绍");

  private String value;
  private String desc;

  SystemSettingsDetailEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (SystemSettingsDetailEnum o : SystemSettingsDetailEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (SystemSettingsDetailEnum o : SystemSettingsDetailEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    SystemSettingsDetailEnum[] types = SystemSettingsDetailEnum.values();
    for(SystemSettingsDetailEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
