package com.biz.crm.member.business.member.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 枚举数据字典：mms_system_settings_type
 *
 * @author hupan
 * @date 2023/6/21 10:32
 */
@Getter
public enum SystemSettingsTypeEnum {
  VALIDITY_PERIOD_OF_POINTS_SETTING("validity_period_of_points_setting","积分有效期设置"),
  BENEFITS_CLASSIFICATION_SETTING("benefits_classification_setting","权益分类设置"),
  APPRECIATION_ADVISOR_CARD("appreciation_advisor_card","品鉴顾问卡片"),
  MEMBERSHIP_FISSION("membership_fission","会员裂变"),
  GROUP_BUYING_CONFIG("group_buying_config","团购设置"),
  CULTURAL_AND_TOURISM_ANSWER_CONFIG("cultural_and_tourism_answer_config","文旅答题配置"),
  CUSTOMER_SERVICE_CONFIG("customer_service_config","客服配置"),
  UPGRADE_RULES("upgrade_rules","升级规则"),
  BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION("business_card_page_company_introduction","名片页面公司介绍");

  private String value;
  private String desc;

  SystemSettingsTypeEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  public static Boolean isExist(String value){
    for (SystemSettingsTypeEnum o : SystemSettingsTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return true;
      }
    }
    return false;
  }
  public static String getDescByValue(String value){
    for (SystemSettingsTypeEnum o : SystemSettingsTypeEnum.values()) {
      if(StringUtils.equals(o.getValue(),value)){
        return o.getDesc();
      }
    }
    return null;
  }


  /**
   * 获取名称
   * @param code
   * @return
   */
  public static String getNameByCode(String code) {
    if(StringUtils.isBlank(code)){
      return "未知";
    }
    SystemSettingsTypeEnum[] types = SystemSettingsTypeEnum.values();
    for(SystemSettingsTypeEnum type : types) {
      if(type.getValue().equals(code)) {
        return type.getDesc();
      }
    }
    return "未知";
  }
}
