package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 消息通知触发条件
 *
 * @Description
 * @Author monroe
 * @Date 2023/7/4 11:33
 **/
public enum TriggerConditionEnum {

    MEMBER_APPROVAL_PASS("member_approval_pass","会员档案审批通过"),
    LEVEL_UP("level_up","等级升级"),
    HOLIDAY_CONF("holiday_conf","根据节日管理配置的节日"),
    LEVEL_EXPIRED("level_expired","等级到期"),
    INTEGRAL_EXPIRED_MOTH("integral_expired_moth","若有积分在本月到期"),
    ORDER_DELIVER("order_deliver","订单状态变更为已发货"),
    ORDER_VERIFICATION("order_verification","订单状态变更为已核销"),
    ORDER_EXPIRED_30("order_expired_30","虚拟订单过期前30天"),
    ACTIVITY_APPROVAL_PASS("activity_approval_pass","活动报名审批通过"),
    ACTIVITY_REJECT("activity_reject","活动报名审批驳回"),
    ACTIVITY_SIGN_3("activity_sign_3","活动报名签到前3天"),
    ACTIVITY_SIGN("activity_sign","活动状态变更为已签到"),
    BIRTHDAY_10("birthday_10","生日前10天"),
    BIRTHDAY_DAY("birthday_day","生日当天"),
    DISCUSS_REJECT("discuss_reject","评论被驳回"),
    DISCUSS_PASS("discuss_pass","评论通过"),
    DISCUSS_BEST("discuss_best","评论加精"),
    BENEFIT_EXCHANGE_SUCCESS("benefit_exchange_success", "权益兑换成功"),
    BENEFIT_NO_CLAIM_30("benefit_no_claim_30", "未领取权益到期前30天");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    TriggerConditionEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (TriggerConditionEnum shelfStatusEnum : TriggerConditionEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static TriggerConditionEnum codeToEnum(String code) {
        TriggerConditionEnum statusEnum = null;
        for (TriggerConditionEnum shelfStatusEnum : TriggerConditionEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            TriggerConditionEnum[] values = TriggerConditionEnum.values();
            for (TriggerConditionEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        TriggerConditionEnum[] values = TriggerConditionEnum.values();
        for (TriggerConditionEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
