package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 消息通知触发类型
 *
 * @Description
 * @Author monroe
 * @Date 2023/7/4 11:23
 **/
public enum TriggerTypeEnum {

    MEMBER("member","会员"),
    HOLIDAY("holiday","节日"),
    LEVEL("level","等级"),
    INTEGRAL("integral","积分"),
    ORDER("order","订单"),
    ACTIVITY("activity","活动"),
    BIRTHDAY("birthday","生日"),
    DISCUSS("discuss","评论"),
    BENEFIT("benefit", "权益");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    TriggerTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (TriggerTypeEnum shelfStatusEnum : TriggerTypeEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static TriggerTypeEnum codeToEnum(String code) {
        TriggerTypeEnum statusEnum = null;
        for (TriggerTypeEnum shelfStatusEnum : TriggerTypeEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            TriggerTypeEnum[] values = TriggerTypeEnum.values();
            for (TriggerTypeEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        TriggerTypeEnum[] values = TriggerTypeEnum.values();
        for (TriggerTypeEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
