package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 应用区域枚举
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/27 17:26
 **/
public enum UseAreaEnum {

    INDEX("index","首页"),
    MALL("mall","积分商城"),
    TOURISM("tourism","文旅"),
    INFO("info", "资讯");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    UseAreaEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (UseAreaEnum shelfStatusEnum : UseAreaEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static UseAreaEnum codeToEnum(String code) {
        UseAreaEnum statusEnum = null;
        for (UseAreaEnum shelfStatusEnum : UseAreaEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            UseAreaEnum[] values = UseAreaEnum.values();
            for (UseAreaEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        UseAreaEnum[] values = UseAreaEnum.values();
        for (UseAreaEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
