package com.biz.crm.member.business.member.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 生效状态
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/27 17:56
 **/
public enum ValidateStatusEnum {

    NO("0","否"),
    YES("1","是");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    ValidateStatusEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ValidateStatusEnum shelfStatusEnum : ValidateStatusEnum.values()) {
            codes.add(shelfStatusEnum.getCode());
        }
        return codes;
    }

    /**
     * 根据code转枚举
     * @param code
     * @return
     */
    public static ValidateStatusEnum codeToEnum(String code) {
        ValidateStatusEnum statusEnum = null;
        for (ValidateStatusEnum shelfStatusEnum : ValidateStatusEnum.values()) {
            if (shelfStatusEnum.code.equals(code)) {
                statusEnum = shelfStatusEnum;
            }
        }
        return statusEnum;
    }
    /**
     * 根据code获取文字描述
     * @param code
     * @return
     */
    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ValidateStatusEnum[] values = ValidateStatusEnum.values();
            for (ValidateStatusEnum value : values) {
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }
        return null;
    }

    /**
     * 判断枚举中是否包含该code
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        ValidateStatusEnum[] values = ValidateStatusEnum.values();
        for (ValidateStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
