package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import java.util.List;

/**
 * 权益管理变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-12 12:28:56
 */
public interface BenefitsManageEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(BenefitsManageVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(BenefitsManageVo oldVo, BenefitsManageVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<BenefitsManageVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<BenefitsManageVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<BenefitsManageVo> list) {

  }
}

