package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import java.util.List;

/**
 * 权益管理-区域有效期配置变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-12 12:38:50
 */
public interface BenefitsManageOrgEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(BenefitsManageOrgVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(BenefitsManageOrgVo oldVo, BenefitsManageOrgVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<BenefitsManageOrgVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<BenefitsManageOrgVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<BenefitsManageOrgVo> list) {

  }
}

