package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import java.util.List;

/**
 * 等级管理-权益配置明细变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-13 09:51:06
 */
public interface LevelManageBenefitsDetailEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(LevelManageBenefitsDetailVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(LevelManageBenefitsDetailVo oldVo, LevelManageBenefitsDetailVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<LevelManageBenefitsDetailVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<LevelManageBenefitsDetailVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<LevelManageBenefitsDetailVo> list) {

  }
}

