package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import java.util.List;

/**
 * 等级管理-权益配置变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-13 09:50:43
 */
public interface LevelManageBenefitsEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(LevelManageBenefitsVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(LevelManageBenefitsVo oldVo, LevelManageBenefitsVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<LevelManageBenefitsVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<LevelManageBenefitsVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<LevelManageBenefitsVo> list) {

  }
}

