package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import java.util.List;

/**
 * 等级管理变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-13 09:50:11
 */
public interface LevelManageEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(LevelManageVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(LevelManageVo oldVo, LevelManageVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<LevelManageVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<LevelManageVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<LevelManageVo> list) {

  }
}

