package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import java.util.List;

/**
 * 会员权益关联表变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-20 15:08:19
 */
public interface MemberInfoBenefitsEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoBenefitsVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoBenefitsVo oldVo, MemberInfoBenefitsVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoBenefitsVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoBenefitsVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoBenefitsVo> list) {

  }
}

