package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import java.util.List;

/**
 * 会员退货记录明细变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-28 16:54:54
 */
public interface MemberInfoComeBackRecordDetailEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoComeBackRecordDetailVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoComeBackRecordDetailVo oldVo, MemberInfoComeBackRecordDetailVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoComeBackRecordDetailVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoComeBackRecordDetailVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoComeBackRecordDetailVo> list) {

  }
}

