package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import java.util.List;

/**
 * 会员退货记录变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-28 16:54:31
 */
public interface MemberInfoComeBackRecordEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoComeBackRecordVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoComeBackRecordVo oldVo, MemberInfoComeBackRecordVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoComeBackRecordVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoComeBackRecordVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoComeBackRecordVo> list) {

  }
}

