package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import java.util.List;

/**
 * 业务员联系人变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-19 14:29:18
 */
public interface MemberInfoContactEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoContactVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoContactVo oldVo, MemberInfoContactVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoContactVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoContactVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoContactVo> list) {

  }
}

