package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import java.util.List;

/**
 * 会员成长值变动记录变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-19 14:29:43
 */
public interface MemberInfoGrowRecordEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoGrowRecordVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoGrowRecordVo oldVo, MemberInfoGrowRecordVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoGrowRecordVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoGrowRecordVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoGrowRecordVo> list) {

  }
}

