package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import java.util.List;

/**
 * 会员积分变动记录变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-19 14:38:19
 */
public interface MemberInfoIntegralRecordEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoIntegralRecordVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoIntegralRecordVo oldVo, MemberInfoIntegralRecordVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoIntegralRecordVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoIntegralRecordVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoIntegralRecordVo> list) {

  }
}

