package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import java.util.List;

/**
 * 会员等级变动记录变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-19 14:30:21
 */
public interface MemberInfoLevelChangeRecordEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoLevelChangeRecordVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoLevelChangeRecordVo oldVo, MemberInfoLevelChangeRecordVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoLevelChangeRecordVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoLevelChangeRecordVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoLevelChangeRecordVo> list) {

  }
}

