package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import java.util.List;

/**
 * 会员签收记录产品明细变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-28 16:54:10
 */
public interface MemberInfoReceiptRecordDetailEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoReceiptRecordDetailVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoReceiptRecordDetailVo oldVo, MemberInfoReceiptRecordDetailVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoReceiptRecordDetailVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoReceiptRecordDetailVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoReceiptRecordDetailVo> list) {

  }
}

