package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import java.util.List;

/**
 * 会员签收记录变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-28 16:53:42
 */
public interface MemberInfoReceiptRecordEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoReceiptRecordVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoReceiptRecordVo oldVo, MemberInfoReceiptRecordVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoReceiptRecordVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoReceiptRecordVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoReceiptRecordVo> list) {

  }
}

