package com.biz.crm.member.business.member.sdk.event;

import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import java.util.List;

/**
 * 会员签到表变更事件通知接口
 *
 * @author zouhs
 * @date 2023-06-27 13:44:25
 */
public interface MemberInfoSignEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(MemberInfoSignVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(MemberInfoSignVo oldVo, MemberInfoSignVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<MemberInfoSignVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<MemberInfoSignVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<MemberInfoSignVo> list) {

  }
}

