
package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动报名记录vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 18:51
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityApplyRecordVo", description = "活动-活动报名记录vo")
public class ActivityApplyRecordVo extends TenantFlagOpVo {

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("报名记录编码")
    private String recordCode;

    @ApiModelProperty("报名时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyDate;


    @ApiModelProperty("报名者姓名")
    private String applyUserName;

    @ApiModelProperty("报名者手机号")
    private String applyUserPhone;


    @ApiModelProperty("报名者关联组织")
    private String applyUserOrg;

    @ApiModelProperty("报名者关联组织名称")
    private String applyUserOrgName;

    @ApiModelProperty("审批状态")
    private String approvalStatus;

    @ApiModelProperty("审批人账号")
    private String approvalUserAccount;

    @ApiModelProperty("审批人名字")
    private String approvalUserName;

    @ApiModelProperty("审批时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date approvalDate;



    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("联系方式")
    private String contactPhone;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty("爱好")
    private String hobby;

    @ApiModelProperty("审批状态")
    private String processStatus;





}
