package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动基础配置分页Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 11:32
 **/
@Data
@ApiModel(value = "ActivityManagePageVo",description = "活动基础配置分页Vo")
public class ActivityManagePageVo extends TenantFlagOpDto {

    @ApiModelProperty("活动编码")
    private String code;

    @ApiModelProperty("活动名称")
    private String name;

    @ApiModelProperty("活动地址")
    private String address;

    @ApiModelProperty("活动说明")
    private String activityDsc;

    @ApiModelProperty("报名是否需要审批")
    private String needApproval;

    @ApiModelProperty("报名是否需要审批")
    private String needApprovalName;

    @ApiModelProperty("报名人数上限数量")
    private Integer applyCeilingNum;

    @ApiModelProperty("报名等级限制")
    private String applyRequire;

    @ApiModelProperty("报名等级限制名称")
    private String applyRequireName;

    @ApiModelProperty("报名时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyStartDate;

    @ApiModelProperty("报名结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyEndDate;

    @ApiModelProperty("签到时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signStartDate;

    @ApiModelProperty("签到结束（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date signEndDate;

    @ApiModelProperty("活动详情")
    private String activityDetailDesc;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("报名时间str")
    private String applyDateStr;

    @ApiModelProperty("签到时间str")
    private String signDateStr;

    @ApiModelProperty("活动状态")
    private String activityStatus;

    @ApiModelProperty("报名人数")
    private String signNum;

    @ApiModelProperty("签到人数")
    private String attendNum;

    //小程序企划活动所用
    //小程序每个活动对用户的状态
    private String statusForUser;
    //审批状态
    private String processStatus;
    //用户名
    private String userName;
    //已报名人数
    private Integer hasJoin;
    //是否签到
    private String hasAttend;

}
