package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

/**
 * @author hupan
 * @date 2023/6/30 11:52
 */
@Data
@ApiModel(value = "AddressManageVo",description = "地址管理Vo")
public class AddressManageVo extends TenantFlagOpVo {

  @ApiModelProperty("收货人手机号")
  private String memberPhone;

  @ApiModelProperty("会员编码,小程序端不需要传,后台需要传")
  private String memberCode;

  @ApiModelProperty("收货人姓名")
  private String memberName;

  @ApiModelProperty("省")
  @TableField(value = "province_code")
  private String provinceCode;

  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  private String provinceName;

  @ApiModelProperty("市")
  @TableField(value = "city_code")
  private String cityCode;

  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  private String cityName;

  @ApiModelProperty("区")
  @TableField(value = "district_code")
  private String districtCode;

  @ApiModelProperty("区名称")
  @TableField(value = "district_name")
  private String districtName;

  @ApiModelProperty("详细地址")
  @TableField(value = "detail_address")
  private String detailAddress;

  @ApiModelProperty("是否为默认地址,数据字典,0表示不是,1表示默认")
  private String flagDefaultAddress;
}
