package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 权益管理vo
 *
 * @author zouhs
 * @date 2023-06-12 12:28:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "权益管理Vo")
public class BenefitsManageVo extends TenantFlagOpVo {

  @ApiModelProperty("权益编码")
  private String code;

  @ApiModelProperty("权益名称")
  private String name;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  private String type;

  @ApiModelProperty("单位,数据字典:mms_benefits_unit,枚举:BenefitsUnitEnum")
  private String unit;

  @ApiModelProperty("产品图片")
  private String productImage;

  @ApiModelProperty("产品详情")
  private String productDesc;

  @ApiModelProperty("兑换有效期(月)")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  private Integer useValidPeriod;

  @ApiModelProperty("区域有效期配置")
  private List<BenefitsManageOrgVo> list;

}

