package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 15:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "权益转移记录Vo")
public class BenefitsTransferRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("权益转入对象")
  private String transferToObjectName;

  @ApiModelProperty("权益转入对象手机号")
  private String transferToObjectPhone;

  @ApiModelProperty("权益转出对象")
  private String transferOutObjectName;

  @ApiModelProperty("权益转出对象手机号")
  private String transferOutObjectPhone;

  @ApiModelProperty("操作人")
  private String operatorName;

  @ApiModelProperty("权益转移时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date transferTime;

  @ApiModelProperty("会员等级")
  private String memberLevel;

  @ApiModelProperty("成长值")
  private Integer growthValue;

  @ApiModelProperty("实物")
  private String substance;

  @ApiModelProperty("虚拟")
  private String virtually;

  @ApiModelProperty("酒卡")
  private String wineCard;

  @ApiModelProperty("积分")
  private Integer integral;

}
