package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 14:11
 * @description 评论管理Vo
 */
@ApiModel(value = "DiscussVo", description = "评论管理Vo")
@Data
public class DiscussVo extends TenantFlagOpVo {
  @ApiModelProperty("评论编码")
  private String code;

  @ApiModelProperty("序号")
  private Integer serialNum;

  @ApiModelProperty("资讯编码")
  private String infoCode;

  @ApiModelProperty("资讯标题")
  private String infoTitle;

  @ApiModelProperty("精选，(0||1)==>（不是||是）")
  private Integer choiceDiscuss;

  @ApiModelProperty("评论人手机号")
  private String discussTel;

  @ApiModelProperty("评论内容")
  private String discussContent;

  @ApiModelProperty("审批状态,字典:mms_discuss_check_status,枚举:DiscussCheckStatusEnum")
  private String checkStatus;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("是否是自己的评论")
  private Boolean owner;

  @ApiModelProperty("评论用户的头像")
  private String avatar;
}
