package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 虚拟订单用户信息vo
 *
 * @author zouhs
 * @date 2023-06-14 15:00:36
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "虚拟订单用户信息Vo")
public class DummyOrderApplyUserVo extends TenantFlagOpVo {

  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("姓名")
  private String name;

  @ApiModelProperty("联系方式")
  private String phone;

  @ApiModelProperty("订单状态,数据字典:mms_dummy_order_status,枚举:DummyOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("下单时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date orderTime;

  @ApiModelProperty("下单人姓名")
  private String orderName;

  @ApiModelProperty("下单人手机号")
  private String orderPhone;

}

