package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 虚拟订单vo
 *
 * @author zouhs
 * @date 2023-06-14 15:00:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "虚拟订单Vo")
public class DummyOrderVo extends WorkflowFlagOpVo {

  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("订单状态,数据字典:mms_dummy_order_status,枚举:DummyOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

  @ApiModelProperty("核销人编码")
  private String writeOffCode;

  @ApiModelProperty("核销人")
  private String writeOffName;

  @ApiModelProperty("关联组织编码")
  private String orgCode;

  @ApiModelProperty("关联组织名称")
  private String orgName;

  @ApiModelProperty("关联经销商编码")
  private String relationAgentCode;

  @ApiModelProperty("关联经销商")
  private String relationAgentName;

  @ApiModelProperty("核销时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date writeOffTime;

  @ApiModelProperty("过期时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date expireTime;

  @ApiModelProperty("关联客户编码")
  private String userCode;

  @ApiModelProperty("关联客户名称")
  private String userName;

  @ApiModelProperty("下单时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date orderTime;

  @ApiModelProperty("下单人姓名")
  private String orderName;

  @ApiModelProperty("下单人手机号")
  private String orderPhone;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("兑换合计支付积分")
  private Integer integralNum;

  @ApiModelProperty("商品缩略图")
  private String productImg;

  @ApiModelProperty("商品价格(单价)")
  private BigDecimal integralPrice;

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品数量")
  private Integer productNum;

  @ApiModelProperty("结算状态,数据字典:mms_order_settle_status,枚举:OrderSettleStatusEnum")
  private String settleStatus;

  @ApiModelProperty("报名人信息")
  private List<DummyOrderUserVo> list;

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  //-关联中奖记录编码-
  @ApiModelProperty("关联中奖记录编码")
  private String relationCode;

}

