package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/30 14:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "小程序成长值记录Vo")
public class GrowRecordAPIVo {

  @ApiModelProperty("来源,枚举:mms_grow_resource,枚举类:GrowResourceEnum")
  private String source;

  @ApiModelProperty("发放时间")
  @TableField(value = "opt_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date optTime;

  @ApiModelProperty("产品名称")
  private String productName;

  @ApiModelProperty("数量")
  private Integer num;

  @ApiModelProperty("成长值")
  private Integer grow;

  @ApiModelProperty("发放流水号,对应签收/退货表里面的单据流水号")
  private String resourceDocumentCode;

  @ApiModelProperty("增加/减少,increase/reduce")
  @Column(name="increase_or_reduce" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String increaseOrReduce;

  @ApiModelProperty("增加/减少,枚举,数据字典:mms_grow_operation,枚举类:GrowOperationEnum")
  private String operationFlag;
}
