package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 会员节日获取积分记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/28 12:05
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayIntegralRecordVo", description = "会员节日获取积分记录Vo")
public class HolidayIntegralRecordVo extends TenantFlagOpVo {

    @ApiModelProperty("节日编码")
    private String holidayCode;

    @ApiModelProperty("会员手机号")
    private String memberPhone;

    @ApiModelProperty("会员编码")
    private String memberCode;

    @ApiModelProperty("获取积分数量")
    private BigDecimal integralNum;

    @ApiModelProperty("获取渠道")
    private String channel;
}
