package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 节日积分倍数vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 11:32
 **/
@Getter
@Setter
@ApiModel(value = "HolidayIntegralVo", description = "节日积分倍数vo")
public class HolidayIntegralVo extends TenantFlagOpVo {

    @ApiModelProperty("节日编码")
    private String holidayCode;

    @ApiModelProperty("渠道,数据字典:mms_channel_type,枚举:ChannelTypeEnum")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("节日积分倍数")
    private BigDecimal multiple;
}
